﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// A combobox to select a codepage encoding. The combobox is filled with entries
    /// of encodings supported by JRE. The user can select one of these default 
    /// encodings or enter a arbitary string as identifier.<br/>
    /// The initial value is the default encoding of the user's system.
    /// </summary>
    public partial class CodepageComboBox : ComboBox
    {
        /// <summary>
        /// Creates a new combobox.
        /// </summary>
        public CodepageComboBox()
        {
            InitializeComponent();
            Text = Encoding.Default.BodyName;
            Items.AddRange(new object[] {
            "ASCII",
            "Big5",
            "Big5_HKSCS",
            "Big5_Solaris",
            "Cp037",
            "Cp1006",
            "Cp1025",
            "Cp1026",
            "Cp1046",
            "Cp1047",
            "Cp1097",
            "Cp1098",
            "Cp1112",
            "Cp1122",
            "Cp1123",
            "Cp1124",
            "Cp1140",
            "Cp1141",
            "Cp1142",
            "Cp1143",
            "Cp1144",
            "Cp1145",
            "Cp1146",
            "Cp1147",
            "Cp1148",
            "Cp1149",
            "Cp1250",
            "Cp1251",
            "Cp1252",
            "Cp1253",
            "Cp1254",
            "Cp1255",
            "Cp1256",
            "Cp1257",
            "Cp1258",
            "Cp1381",
            "Cp1383",
            "Cp273",
            "Cp277",
            "Cp278",
            "Cp280",
            "Cp284",
            "Cp285",
            "Cp297",
            "Cp33722",
            "Cp420",
            "Cp424",
            "Cp437",
            "Cp500",
            "Cp737",
            "Cp775",
            "Cp834",
            "Cp838",
            "Cp850",
            "Cp852",
            "Cp855",
            "Cp856",
            "Cp857",
            "Cp858",
            "Cp860",
            "Cp861",
            "Cp862",
            "Cp863",
            "Cp864",
            "Cp865",
            "Cp866",
            "Cp868",
            "Cp869",
            "Cp870",
            "Cp871",
            "Cp874",
            "Cp875",
            "Cp918",
            "Cp921",
            "Cp922",
            "Cp930",
            "Cp933",
            "Cp935",
            "Cp937",
            "Cp939",
            "Cp942",
            "Cp942C",
            "Cp943",
            "Cp943C",
            "Cp948",
            "Cp949",
            "Cp949C",
            "Cp950",
            "Cp964",
            "Cp970",
            "EUC_CN",
            "EUC_JP",
            "EUC_JP_LINUX",
            "EUC_JP_Solaris",
            "EUC_KR",
            "EUC_TW",
            "GB18030",
            "GBK",
            "HKSCS",
            "HKSCS_2001",
            "ISCII91",
            "ISO2022JP",
            "ISO2022KR",
            "ISO8859_1",
            "ISO8859_13",
            "ISO8859_15",
            "ISO8859_2",
            "ISO8859_3",
            "ISO8859_4",
            "ISO8859_5",
            "ISO8859_6",
            "ISO8859_7",
            "ISO8859_8",
            "ISO8859_9",
            "JIS0201",
            "JIS0208",
            "JIS0208_Solaris",
            "JIS0212",
            "JIS0212_Solaris",
            "Johab",
            "KOI8_R",
            "MacArabic",
            "MacCentralEurope",
            "MacCroatian",
            "MacCyrillic",
            "MacDingbat",
            "MacGreek",
            "MacHebrew",
            "MacIceland",
            "MacRoman",
            "MacRomania",
            "MacSymbol",
            "MacThai",
            "MacTurkish",
            "MacUkraine",
            "MS874",
            "MS932",
            "MS936",
            "MS949",
            "MS950",
            "MS950_HKSCS",
            "PCK",
            "SJIS",
            "TIS620",
            "Unicode",
            "UnicodeBig",
            "UnicodeBigUnmarked",
            "UnicodeLittle",
            "UnicodeLittleUnmarked",
            "UTF16",
            "UTF8"});
        } 
    }
}
